<?php
/**
 * Plugin Name: Movapay Gateway
 * Description: Intégration Movapay (OAuth2 client credentials) — création de liens de paiement + option WooCommerce.
 * Version: 0.1.0
 * Author: Movapay
 * Requires at least: 6.0
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) {
    exit;
}

define('MOVAPAY_GATEWAY_VERSION', '0.1.0');
define('MOVAPAY_GATEWAY_SLUG', 'movapay-gateway');

require_once __DIR__ . '/includes/class-movapay-client.php';
require_once __DIR__ . '/includes/class-movapay-settings.php';
require_once __DIR__ . '/includes/class-movapay-shortcodes.php';
require_once __DIR__ . '/includes/class-movapay-webhook.php';

add_action('admin_menu', ['Movapay_Settings', 'register_menu']);
add_action('admin_init', ['Movapay_Settings', 'register_settings']);
add_action('init', ['Movapay_Shortcodes', 'register']);
add_action('rest_api_init', ['Movapay_Webhook', 'register_routes']);

// Optional WooCommerce gateway
add_action('plugins_loaded', function () {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    require_once __DIR__ . '/includes/class-wc-gateway-movapay.php';

    add_filter('woocommerce_payment_gateways', function ($gateways) {
        $gateways[] = 'WC_Gateway_Movapay';
        return $gateways;
    });
});


