<?php

if (!defined('ABSPATH')) {
    exit;
}

class WC_Gateway_Movapay extends WC_Payment_Gateway {
    public function __construct() {
        $this->id = 'movapay';
        $this->method_title = 'Movapay';
        $this->method_description = 'Paiement via Movapay (redirection).';
        $this->has_fields = false;

        $this->init_form_fields();
        $this->init_settings();

        $this->title = $this->get_option('title', 'Movapay');
        $this->description = $this->get_option('description', 'Payer via Movapay');

        add_action('woocommerce_update_options_payment_gateways_' . $this->id, [$this, 'process_admin_options']);
    }

    public function init_form_fields() {
        $this->form_fields = [
            'enabled' => [
                'title' => 'Activer/Désactiver',
                'type' => 'checkbox',
                'label' => 'Activer Movapay',
                'default' => 'no',
            ],
            'title' => [
                'title' => 'Titre',
                'type' => 'text',
                'default' => 'Movapay',
            ],
            'description' => [
                'title' => 'Description',
                'type' => 'textarea',
                'default' => 'Payer via Movapay',
            ],
        ];
    }

    public function process_payment($order_id) {
        $order = wc_get_order($order_id);
        if (!$order) {
            return ['result' => 'fail'];
        }

        $amount = (float) $order->get_total();
        $currency = $order->get_currency();
        $desc = sprintf('Commande #%s', $order->get_order_number());

        $return_url = $order->get_checkout_order_received_url();
        $cancel_url = wc_get_checkout_url();

        $payload = [
            'amount' => $amount,
            'currency' => $currency,
            'description' => $desc,
            'customer_email' => $order->get_billing_email(),
            'customer_phone' => $order->get_billing_phone(),
            'return_url' => $return_url,
            'cancel_url' => $cancel_url,
        ];

        $res = Movapay_Client::create_payment_link($payload);
        if (is_wp_error($res)) {
            wc_add_notice($res->get_error_message(), 'error');
            return ['result' => 'fail'];
        }

        $payment_url = !empty($res['payment_url']) ? $res['payment_url'] : (!empty($res['payment_link']) ? $res['payment_link'] : '');
        if (!$payment_url) {
            wc_add_notice('Movapay: payment_url manquant.', 'error');
            return ['result' => 'fail'];
        }

        // Put order on hold until webhook / reconciliation
        $order->update_status('on-hold', 'En attente de paiement Movapay.');

        return [
            'result' => 'success',
            'redirect' => $payment_url,
        ];
    }
}


