<?php

if (!defined('ABSPATH')) {
    exit;
}

class Movapay_Webhook {
    public static function register_routes() {
        register_rest_route('movapay/v1', '/webhook', [
            'methods' => 'POST',
            'permission_callback' => '__return_true',
            'callback' => [self::class, 'handle'],
        ]);
    }

    private static function sort_keys_recursive($value) {
        if (is_array($value)) {
            $is_assoc = array_keys($value) !== range(0, count($value) - 1);
            if ($is_assoc) {
                ksort($value);
            }
            foreach ($value as $k => $v) {
                $value[$k] = self::sort_keys_recursive($v);
            }
        }
        return $value;
    }

    public static function handle(WP_REST_Request $request) {
        $raw = $request->get_body();
        $sig = $request->get_header('x-signature');

        $master_key = Movapay_Client::get_option('master_key', '');
        if (!$master_key) {
            return new WP_REST_Response(['success' => false, 'error' => 'master_key manquant (plugin settings).'], 400);
        }
        if (!$sig) {
            return new WP_REST_Response(['success' => false, 'error' => 'X-Signature manquant.'], 400);
        }

        $payload = json_decode($raw, true);
        if (!is_array($payload)) {
            return new WP_REST_Response(['success' => false, 'error' => 'JSON invalide.'], 400);
        }

        // Rebuild canonical JSON (sort keys, no spaces) to match backend signature generation.
        $payload_sorted = self::sort_keys_recursive($payload);
        $canonical = wp_json_encode($payload_sorted, JSON_UNESCAPED_SLASHES);
        $computed = hash_hmac('sha512', $canonical, $master_key);

        if (!hash_equals($computed, $sig)) {
            return new WP_REST_Response(['success' => false, 'error' => 'Signature invalide.'], 403);
        }

        /**
         * Hook for site-specific handling (subscriptions, services, etc.)
         *
         * Payload example:
         * - $payload['custom_data']['token']
         * - $payload['status'] (success/failed)
         * - $payload['transaction_ref']
         */
        do_action('movapay_webhook_verified', $payload);

        return new WP_REST_Response(['success' => true], 200);
    }
}


