<?php

if (!defined('ABSPATH')) {
    exit;
}

class Movapay_Shortcodes {
    public static function register() {
        add_shortcode('movapay_pay_button', [self::class, 'pay_button']);
    }

    public static function pay_button($atts) {
        $atts = shortcode_atts([
            'amount' => '0',
            'currency' => 'XOF',
            'description' => 'Paiement Movapay',
            'customer_email' => '',
            'customer_phone' => '',
            'return_url' => '',
            'cancel_url' => '',
            'label' => 'Payer avec Movapay',
        ], $atts);

        $amount = floatval($atts['amount']);
        if ($amount <= 0) {
            return '<p><strong>Movapay:</strong> montant invalide.</p>';
        }

        $return_url = $atts['return_url'] ?: Movapay_Client::get_option('default_return_url', '');
        $cancel_url = $atts['cancel_url'] ?: Movapay_Client::get_option('default_cancel_url', '');

        $payload = [
            'amount' => $amount,
            'currency' => $atts['currency'],
            'description' => $atts['description'],
        ];
        if (!empty($atts['customer_email'])) {
            $payload['customer_email'] = $atts['customer_email'];
        }
        if (!empty($atts['customer_phone'])) {
            $payload['customer_phone'] = $atts['customer_phone'];
        }
        if (!empty($return_url)) {
            $payload['return_url'] = $return_url;
        }
        if (!empty($cancel_url)) {
            $payload['cancel_url'] = $cancel_url;
        }

        $res = Movapay_Client::create_payment_link($payload);
        if (is_wp_error($res)) {
            return '<p><strong>Movapay:</strong> ' . esc_html($res->get_error_message()) . '</p>';
        }

        $payment_url = '';
        if (!empty($res['payment_url'])) {
            $payment_url = $res['payment_url'];
        } elseif (!empty($res['payment_link'])) {
            $payment_url = $res['payment_link'];
        }

        if (!$payment_url) {
            return '<p><strong>Movapay:</strong> réponse invalide (payment_url manquant).</p>';
        }

        $label = esc_html($atts['label']);
        $href = esc_url($payment_url);

        return '<a class="button" href="' . $href . '" rel="nofollow noopener">' . $label . '</a>';
    }
}


