<?php

if (!defined('ABSPATH')) {
    exit;
}

class Movapay_Settings {
    public static function register_menu() {
        add_options_page(
            'Movapay',
            'Movapay',
            'manage_options',
            MOVAPAY_GATEWAY_SLUG,
            [self::class, 'render_page']
        );
    }

    public static function register_settings() {
        register_setting('movapay_gateway', 'movapay_gateway_options', [
            'type' => 'array',
            'sanitize_callback' => [self::class, 'sanitize'],
            'default' => [],
        ]);

        add_settings_section(
            'movapay_gateway_main',
            'Configuration Movapay',
            function () {
                echo '<p>Renseignez les informations OAuth2 (Client Credentials) et l’Integration ID.</p>';
            },
            MOVAPAY_GATEWAY_SLUG
        );

        self::add_field('base_url', 'Base URL', 'https://movapay.net');
        self::add_field('client_id', 'Client ID', '');
        self::add_field('client_secret', 'Client Secret', '', true);
        self::add_field('master_key', 'Master Key (webhook signature)', '', true);
        self::add_field('integration_id', 'Integration ID', '');
        self::add_field('default_return_url', 'Return URL (optionnel)', '');
        self::add_field('default_cancel_url', 'Cancel URL (optionnel)', '');
    }

    private static function add_field($key, $label, $placeholder = '', $is_password = false) {
        add_settings_field(
            'movapay_' . $key,
            esc_html($label),
            function () use ($key, $placeholder, $is_password) {
                $opts = get_option('movapay_gateway_options', []);
                $val = isset($opts[$key]) ? $opts[$key] : '';
                $type = $is_password ? 'password' : 'text';
                printf(
                    '<input type="%s" class="regular-text" name="movapay_gateway_options[%s]" value="%s" placeholder="%s" />',
                    esc_attr($type),
                    esc_attr($key),
                    esc_attr($val),
                    esc_attr($placeholder)
                );
                if ($key === 'base_url') {
                    echo '<p class="description">Ex: https://movapay.net (sans slash final)</p>';
                }
                if ($key === 'integration_id') {
                    echo '<p class="description">Ex: INT-XXXX (visible dans le dashboard Movapay)</p>';
                }
            },
            MOVAPAY_GATEWAY_SLUG,
            'movapay_gateway_main'
        );
    }

    public static function sanitize($input) {
        $out = [];
        $fields = [
            'base_url',
            'client_id',
            'client_secret',
            'master_key',
            'integration_id',
            'default_return_url',
            'default_cancel_url',
        ];
        foreach ($fields as $f) {
            $out[$f] = isset($input[$f]) ? sanitize_text_field($input[$f]) : '';
        }
        return $out;
    }

    public static function render_page() {
        if (!current_user_can('manage_options')) {
            return;
        }
        ?>
        <div class="wrap">
            <h1>Movapay</h1>
            <p>Ce plugin utilise OAuth2 <code>client_credentials</code> pour appeler l’API Movapay et créer des liens de paiement.</p>
            <form method="post" action="options.php">
                <?php
                settings_fields('movapay_gateway');
                do_settings_sections(MOVAPAY_GATEWAY_SLUG);
                submit_button('Enregistrer');
                ?>
            </form>
            <hr />
            <h2>Test rapide</h2>
            <p>Shortcode: <code>[movapay_pay_button amount="1000" description="Commande #123"]</code></p>
        </div>
        <?php
    }
}


