# Movapay Gateway (WordPress)

Plugin WordPress “installable” pour intégrer Movapay via OAuth2 **client_credentials**.

## Installation

- Copier le dossier `movapay-gateway/` dans `wp-content/plugins/`
- Activer **Movapay Gateway** dans WordPress

## Configuration

Dans **Réglages → Movapay** :

- **Base URL**: `https://movapay.net` (ou votre domaine)
- **Client ID / Client Secret**: identifiants OAuth2 (application Movapay)
- **Master Key**: clé de signature webhook (pour vérifier `X-Signature`)
- **Integration ID**: identifiant de l’intégration (ex: `INT-...`)
- **Return URL / Cancel URL** (optionnel): valeurs par défaut pour les redirections

## Utilisation

### Shortcode (hors WooCommerce)

Exemple:

`[movapay_pay_button amount="1000" description="Commande #123" label="Payer maintenant"]`

### WooCommerce (optionnel)

Si WooCommerce est activé, le plugin ajoute une méthode de paiement **Movapay**.

Notes:
- Le checkout redirige vers `payment_url`
- La mise à jour “payé” doit idéalement être faite via webhook/callback.

## Webhook (server-to-server)

Endpoint WordPress:

- `POST /wp-json/movapay/v1/webhook`
- Header: `X-Signature` (HMAC-SHA512)

Pour recevoir les notifications, configurez côté Movapay l’URL de callback de votre intégration vers cet endpoint.

## Documentation complète

Voir `docs/PLUGINS_WORDPRESS_ODOO.md`


