# Movapay Payment (Odoo)

Module Odoo pour générer des **liens de paiement Movapay** depuis les factures client, via OAuth2 `client_credentials`.

## Installation

- Copier le dossier `movapay_payment/` dans votre addons path
- Mettre à jour la liste des Apps
- Installer **Movapay Payment (Links)**

## Configuration

Aller dans **Paramètres → Movapay** :

- Base URL (ex: `https://movapay.net`)
- Client ID / Client Secret (OAuth2)
- Master Key (signature webhook)
- Integration ID
- (optionnel) Return URL / Cancel URL

## Utilisation

Sur une facture client (validée/postée):
- Cliquer **Générer lien Movapay**
- Copier `Movapay Payment URL` et l’envoyer au client

## Notes

- Ce module **ne réconcilie pas automatiquement** la facture (webhook à brancher selon votre process).
- Le token OAuth2 est mis en cache dans `ir.config_parameter`.

## Webhook (server-to-server)

Endpoint Odoo:
- `POST /movapay/webhook`
- Header: `X-Signature` (HMAC-SHA512) — vérifié sur le body brut

Configure l’URL de callback de ton intégration Movapay vers cet endpoint.

## Documentation complète

Voir `docs/PLUGINS_WORDPRESS_ODOO.md`


